

if ( SERVER ) then

	AddCSLuaFile( "shared.lua" )
	
end

ENT.Type 			= "anim"
ENT.Base 			= "base_anim"
ENT.PrintName		= "Rocket"

ENT.Spawnable			= false
ENT.AdminSpawnable		= false




function ENT:Initialize()
	self:SetModel("models/weapons/kp_rocket.mdl")

	self:SetCollisionGroup(COLLISION_GROUP_PROJECTILE)
	self:PhysicsInit(SOLID_VPHYSICS)
	self:SetMoveType(MOVETYPE_VPHYSICS)
	self:SetSolid(SOLID_CUSTOM)
	self.Entity:SetRenderMode(RENDERMODE_TRANSALPHA)
	if (SERVER) then
local zfire = ents.Create( "env_fire_trail" )
		zfire:SetPos( self:GetPos() )
		zfire:SetParent( self )
		zfire:Spawn()
		zfire:Activate()
        end
	local phys = self:GetPhysicsObject()
	if IsValid(phys) then
		phys:Wake()
		phys:SetMass(1)
		phys:EnableDrag(false)
		phys:EnableGravity(false)
		phys:SetBuoyancyRatio(0)
	end
	
	self.deployDelay = CurTime() +5.1
end
	


function ENT:SetEntityOwner(ent)
	self:SetOwner(ent)
	self.entOwner = ent
end

function ENT:PhysicsCollide(data, physobj)
	local start = data.HitPos + data.HitNormal
    local endpos = data.HitPos - data.HitNormal
	util.Decal("Scorch",start,endpos)
	self:Explode()
	return true
end

function ENT:Explode()
	util.BlastDamage( self, self:GetOwner(), self:GetPos(), 160, 160 )
	local effectdata = EffectData()
	local rocketexp =  ("grenadek/explosion"..(math.random (1,2))..".wav")
	effectdata:SetStart( self:GetPos() )
	effectdata:SetOrigin( self:GetPos() )
	effectdata:SetScale( 5 )
	util.Effect( "kexplode", effectdata ) 
	self:EmitSound(rocketexp, 100, math.random(95,105))

	self:Remove()
end

function ENT:OnRemove()
	if self.flysound then self.flysound:Stop() end
end



function ENT:Think()
	if self.deployDelay then
		//if CurTime() < self.deployDelay then return end
		self.deployDelay = nil
		self.flysound = CreateSound(self, "v_rpgk/rl_rocket.wav")
		self.flysound:Play()

	end
	local phys = self:GetPhysicsObject()
	if IsValid(phys) then phys:SetVelocity(self:GetAngles():Forward() *1500) return end
end
